/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class NetherLandStructures
extends Structure {
    public static final Codec<NetherLandStructures> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NetherLandStructures.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, NetherLandStructures::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public NetherLandStructures(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122178_(chunkpos.m_151390_(), 25, chunkpos.m_151393_());
        int maxHeight = 100;
        NoiseColumn blockView = context.f_226622_().m_214184_(mutable.m_123341_(), mutable.m_123343_(), context.f_226629_(), context.f_226624_());
        while (mutable.m_123342_() < maxHeight) {
            BlockState state = blockView.m_183556_(mutable.m_123342_());
            BlockState upperState = blockView.m_183556_(mutable.m_123342_() + 1);
            BlockState upperUpperState = blockView.m_183556_(mutable.m_123342_() + 1);
            if (!state.m_60795_() && upperState.m_60795_() && upperUpperState.m_60795_()) {
                return true;
            }
            mutable.m_122173_(Direction.UP);
        }
        return false;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122178_(chunkPos.m_45604_(), 25, chunkPos.m_45605_());
        int maxHeight = 100;
        NoiseColumn blockView = context.f_226622_().m_214184_(mutable.m_123341_(), mutable.m_123343_(), context.f_226629_(), context.f_226624_());
        int startY = -1;
        while (mutable.m_123342_() < maxHeight) {
            BlockState state = blockView.m_183556_(mutable.m_123342_());
            boolean isAirAbove = true;
            for (int i = 1; i < 8; ++i) {
                if (blockView.m_183556_(mutable.m_123342_() + i).m_60795_()) continue;
                isAirAbove = false;
                break;
            }
            if (!state.m_60795_() && !state.m_60713_(Blocks.f_49991_) && isAirAbove) {
                startY = mutable.m_123342_() + 2;
                break;
            }
            mutable.m_122173_(Direction.UP);
        }
        if (startY == -1) {
            return Optional.empty();
        }
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ModRegistries.NETHER_STRUCTURES.get();
    }
}

